(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     66044,       1301]
NotebookOptionsPosition[     65117,       1277]
NotebookOutlinePosition[     65546,       1294]
CellTagsIndexPosition[     65503,       1291]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"r", " ", "=", " ", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", " ", "=", " ", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", " ", "=", " ", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", " ", "0.34"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", " ", "=", " ", "0.95"}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"L1", " ", "=", 
  RowBox[{
   RowBox[{"k2", " ", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]], ")"}]}], "+", 
   RowBox[{"k1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", 
          RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["h", "\[Alpha]"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", 
            RowBox[{"r", " ", "\[Sigma]"}]}], ")"}], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], ")"}], "/", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], 
     "2"]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"L2", " ", "=", " ", 
  RowBox[{
   RowBox[{"k2", " ", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]], ")"}]}], "+", 
   RowBox[{"k1", " ", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", 
         RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], ")"}]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", 
      RowBox[{"2", " ", "\[Alpha]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L3", " ", "=", 
   RowBox[{
    RowBox[{"k2", " ", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]], ")"}]}], "+", 
    RowBox[{"k1", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", 
           RowBox[{"r", " ", "\[Sigma]"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ")"}]}], "+", "4", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["h", "\[Alpha]"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Sigma]"}], ")"}]}], "-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"d", "-", 
             RowBox[{"r", " ", "\[Sigma]"}]}], ")"}], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]]}], ")"}]}], ")"}], 
     "/", 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}]}], 
  "\[IndentingNewLine]", "\n"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9320856974625473`*^9, 3.932085714574583*^9}, {
   3.9320859464146233`*^9, 3.9320860679663486`*^9}, {3.932086101563656*^9, 
   3.932086117578472*^9}, {3.9320861570844345`*^9, 3.9320861770391045`*^9}, {
   3.932086211648443*^9, 3.9320863492816544`*^9}, {3.932086427850876*^9, 
   3.932086432563673*^9}, {3.9320865648242855`*^9, 3.932086571825968*^9}, {
   3.955705250998022*^9, 3.955705354337143*^9}, {3.9557055544660873`*^9, 
   3.9557055596759357`*^9}, {3.9557055981142406`*^9, 3.955705643998495*^9}, {
   3.9557057044955196`*^9, 3.955705864896471*^9}, {3.9557060493307095`*^9, 
   3.955706054762556*^9}, {3.955706150411703*^9, 3.9557062375532455`*^9}, 
   3.955708111688051*^9, {3.955708455686323*^9, 3.9557085064646664`*^9}, 
   3.9557087363651447`*^9, {3.955708774670376*^9, 3.955708775238962*^9}, {
   3.9557088307952385`*^9, 3.955709234872734*^9}, {3.955709273156046*^9, 
   3.95570934705348*^9}, {3.955769113677597*^9, 3.9557691463809166`*^9}, {
   3.955770214628334*^9, 3.9557702610189934`*^9}, 3.955772363630165*^9, {
   3.955772396588915*^9, 3.955772419692518*^9}, 3.9557738812086716`*^9, 
   3.9557739305401497`*^9, {3.9557740289662247`*^9, 3.9557740435398827`*^9}, {
   3.95577409850515*^9, 3.9557740989363728`*^9}, 3.9557742545900745`*^9, {
   3.9557744374330444`*^9, 3.955774441650976*^9}, {3.955775040566492*^9, 
   3.9557750447907352`*^9}, 3.955775177652096*^9, 3.955775326558262*^9, {
   3.9557755367470856`*^9, 3.9557755603893967`*^9}, {3.958838490083885*^9, 
   3.95883849195129*^9}, 3.958838580759718*^9, {3.9600259368152695`*^9, 
   3.960025959102661*^9}, {3.960026010075552*^9, 3.9600260153239594`*^9}, {
   3.9600260649380665`*^9, 3.9600260699026566`*^9}, {3.960026119106039*^9, 
   3.9600261849343815`*^9}, {3.9600262296308193`*^9, 
   3.9600262442093678`*^9}, {3.9600264295173283`*^9, 3.960026457513752*^9}, {
   3.9600266216557884`*^9, 3.960026706581768*^9}, {3.960026745758196*^9, 
   3.960026768083626*^9}, {3.9739292755091667`*^9, 3.973929319275049*^9}, 
   3.973935139884964*^9, {3.973935237688141*^9, 3.973935241056141*^9}, 
   3.9739352909040985`*^9, 3.973936951463009*^9, 3.97393777512031*^9, {
   3.97540774760211*^9, 3.975407797581972*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"10f8ced2-bf84-5b49-9466-c4cb45b78aa7"],

Cell[BoxData[
 RowBox[{"0.026425359338555585`", "\[VeryThinSpace]", "-", 
  RowBox[{"0.9566458429582145`", " ", "k1"}], "+", 
  RowBox[{"0.5852811200641046`", " ", "k2"}]}]], "Output",
 CellChangeTimes->{3.975407824670038*^9, 3.975407855901018*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"b4ab4296-a25c-9c46-9dfb-9bbbd8270fe3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0697795163803411`"}], "-", 
  RowBox[{"0.04335415704178552`", " ", "k1"}], "-", 
  RowBox[{"0.5852811200641046`", " ", "k2"}]}]], "Output",
 CellChangeTimes->{3.975407824670038*^9, 3.9754078559040127`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"5c9050dd-a30d-7046-bbcd-05649c4cce83"],

Cell[BoxData[
 RowBox[{"3.9830712022967703`", "\[VeryThinSpace]", "-", 
  RowBox[{"1.9566458429582145`", " ", "k1"}], "+", 
  RowBox[{"0.5852811200641046`", " ", "k2"}]}]], "Output",
 CellChangeTimes->{3.975407824670038*^9, 3.975407855905012*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"ef7d568a-aa64-e344-b79b-105d95b9c83e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"cp", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.956646"}], " ", "k1"}], "+", 
          RowBox[{"0.585281", " ", "k2"}]}], "==", 
         RowBox[{"-", "0.0264254"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.0433542"}], " ", "k1"}], "-", 
          RowBox[{"0.585281", " ", "k2"}]}], "==", "0.0697795"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1.95665"}], " ", "k1"}], "+", 
          RowBox[{"0.585281", " ", "k2"}]}], "==", 
         RowBox[{"-", "3.98307"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k1", ",", 
        RowBox[{"-", "6"}], ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k2", ",", 
        RowBox[{"-", "6"}], ",", "8"}], "}"}], ",", 
      RowBox[{"ContourStyle", "->", 
       RowBox[{"{", 
        RowBox[{"Green", ",", "Red", ",", "Black"}], "}"}]}], ",", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"Placed", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<L1\>\"", ",", "\"\<L2\>\"", ",", "\"\<L3\>\""}], "}"}],
          ",", "Right"}], "]"}]}], ",", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Subscript", "[", 
          RowBox[{"k", ",", "1"}], "]"}], ",", 
         RowBox[{"Subscript", "[", 
          RowBox[{"k", ",", "2"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "->", "True"}], ",", 
      RowBox[{"FrameStyle", "->", "Black"}], ",", 
      RowBox[{"LabelStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "Bold", ",", "14"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "->", "Large"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"reg", "=", 
    RowBox[{"RegionPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.956646"}], " ", "k1"}], "+", 
          RowBox[{"0.585281", " ", "k2"}]}], "<", 
         RowBox[{"-", "0.0264254"}]}], ")"}], "&&", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.0433542"}], " ", "k1"}], "-", 
          RowBox[{"0.585281", " ", "k2"}]}], "<", "0.0697795"}], ")"}], "&&", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1.95665"}], " ", "k1"}], "+", 
          RowBox[{"0.585281", " ", "k2"}]}], ">", 
         RowBox[{"-", "3.98307"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k1", ",", 
        RowBox[{"-", "6"}], ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k2", ",", 
        RowBox[{"-", "6"}], ",", "8"}], "}"}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{"Opacity", "[", 
         RowBox[{"0.25", ",", "Yellow"}], "]"}], "]"}]}], ",", 
      RowBox[{"BoundaryStyle", "->", "None"}], ",", 
      RowBox[{"PlotPoints", "->", "100"}]}], "]"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"reg", ",", "cp"}], "]"}]}], "Input",
 CellChangeTimes->{{3.975407842884432*^9, 3.975407844090025*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"2e0abfab-0379-314c-a192-37a3879a8f24"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      GraphicsComplexBox[CompressedData["
1:eJx1XHlYjdv3r9Ncp+k0E4V0pUTGyG0vEonoRkWkJEWiG4kMoYgMiXCjcolI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       "], {{{
          EdgeForm[], 
          Directive[
           AbsoluteThickness[2.], 
           RGBColor[1, 1, 0], 
           Opacity[0.25]], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxNnAn4l8MWx9/1Zy9bUVpICCVRKUUSRdGKlCRtVIpIZQnZkr1rCXUj+5p9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             "]], 
            PolygonBox[CompressedData["
1:eJwtmAf8j9Uex3/P85zzcxtGw0hD66ZBpXI1pbpC3eIaUSkZFRKRS1KRkWwy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             "]]}]}, {}, {}, {}, {}}}], {}}, {
      GraphicsComplexBox[CompressedData["
1:eJxFl3s8VNv7x8dlGDMuY2aM61Qnl6RwEClprUJOp1RIJaGkGAm5JapfJV2U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       "], {{{}, {}, 
         TagBox[
          TooltipBox[{
            Directive[
             AbsoluteThickness[2], 
             RGBColor[0, 1, 0]], 
            
            LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
             17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
             33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
             49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 
             65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
             81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 
             97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109}]}, 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "0.956646`"}], " ", 
                 TagBox["k1", HoldForm]}], "+", 
               RowBox[{"0.585281`", " ", 
                 TagBox["k2", HoldForm]}]}], "\[Equal]", 
             RowBox[{"-", "0.0264254`"}]}]], 
          Annotation[#, (-0.956646) HoldForm[$CellContext`k1] + 
            0.585281 HoldForm[$CellContext`k2] == -0.0264254, "Tooltip"]& ], 
         TagBox[
          TooltipBox[{
            Directive[
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0]], 
            
            LineBox[{110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 
             121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 
             134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 
             147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 
             160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
             173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 
             186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197}]}, 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "0.0433542`"}], " ", 
                 TagBox["k1", HoldForm]}], "-", 
               RowBox[{"0.585281`", " ", 
                 TagBox["k2", HoldForm]}]}], "\[Equal]", "0.0697795`"}]], 
          Annotation[#, (-0.0433542) HoldForm[$CellContext`k1] - 0.585281 
            HoldForm[$CellContext`k2] == 0.0697795, "Tooltip"]& ], 
         TagBox[
          TooltipBox[{
            Directive[
             AbsoluteThickness[2], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJwNz2ciggEAANAvmSF7RCLUgboBB+CWskciO2SPzOzU+/EO8JKz85m5UBAE
MyyQZZEllllhlTXW2WCTLXJsk2eHXQrssc8BhxxxzAlFTjnjnBIXXHLFNTfc
csc9DzxS5olnXnjljXcqfPDJF9/88MsfVf6pEQiHaCBMI00000IrbURop4NO
onTRTQ+99NHPAIMMMUyMEUaJM0aCcSZIMskU06RIUwfUAThy
             "]]}, 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "1.95665`"}], " ", 
                 TagBox["k1", HoldForm]}], "+", 
               RowBox[{"0.585281`", " ", 
                 TagBox["k2", HoldForm]}]}], "\[Equal]", 
             RowBox[{"-", "3.98307`"}]}]], 
          Annotation[#, (-1.95665) HoldForm[$CellContext`k1] + 
            0.585281 HoldForm[$CellContext`k2] == -3.98307, 
           "Tooltip"]& ]}}], {}}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 1, Axes -> {False, False}, 
     AxesLabel -> {None, None}, AxesOrigin -> {Automatic, Automatic}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "ScalingFunctions" -> None, "TransparentPolygonMesh" -> True, 
       "AxesInFront" -> True}, PlotRange -> {{-6, 8}, {-6, 8}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"L1\"", "\"L2\"", "\"L3\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    GrayLevel[0]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[2], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[
           GrayLevel[0], Bold, 14], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[0, 1, 0]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"], ",", "Bold", ",", "14"}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.9754078614004517`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"603f1073-3759-dd4e-b540-204dbee7910f"]
}, Open  ]]
},
WindowSize->{949, 526.5},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>0.75 Inherited,
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"165566d7-9ec1-c342-98f0-21644b35e13c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 7178, 186, 222, "Input",ExpressionUUID->"10f8ced2-bf84-5b49-9466-c4cb45b78aa7"],
Cell[7761, 210, 327, 5, 24, "Output",ExpressionUUID->"b4ab4296-a25c-9c46-9dfb-9bbbd8270fe3"],
Cell[8091, 217, 326, 6, 24, "Output",ExpressionUUID->"5c9050dd-a30d-7046-bbcd-05649c4cce83"],
Cell[8420, 225, 325, 5, 24, "Output",ExpressionUUID->"ef7d568a-aa64-e344-b79b-105d95b9c83e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8782, 235, 3398, 96, 121, "Input",ExpressionUUID->"2e0abfab-0379-314c-a192-37a3879a8f24"],
Cell[12183, 333, 52918, 941, 304, "Output",ExpressionUUID->"603f1073-3759-dd4e-b540-204dbee7910f"]
}, Open  ]]
}
]
*)

